/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.equipment.bell;

import com.zurrtum.create.client.content.equipment.bell.SoulPulseEffect;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1937;
import net.minecraft.class_2338;

@Environment(value=EnvType.CLIENT)
public class SoulPulseEffectHandler {
    private final List<SoulPulseEffect> pulses = new LinkedList<SoulPulseEffect>();
    private final Queue<SoulPulseEffect> queue = new ConcurrentLinkedQueue<SoulPulseEffect>();
    private final Set<class_2338> occupied = new HashSet<class_2338>();

    public void tick(class_1937 world) {
        List<class_2338> spawns;
        SoulPulseEffect pulse;
        Iterator<SoulPulseEffect> iterator = this.pulses.iterator();
        while (iterator.hasNext()) {
            pulse = iterator.next();
            spawns = pulse.tick(world);
            if (spawns != null) {
                if (pulse.canOverlap()) {
                    for (class_2338 pos : spawns) {
                        pulse.spawnParticles(world, pos);
                    }
                    if (!pulse.finished()) continue;
                    iterator.remove();
                    continue;
                }
                if (pulse.finished()) {
                    for (class_2338 pos : spawns) {
                        if (this.occupied.contains(pos)) continue;
                        pulse.spawnParticles(world, pos);
                    }
                    pulse.added.forEach(this.occupied::remove);
                    iterator.remove();
                    continue;
                }
                for (class_2338 pos : spawns) {
                    if (!this.occupied.add(pos)) continue;
                    pulse.spawnParticles(world, pos);
                    pulse.added.add(pos);
                }
                continue;
            }
            if (!pulse.finished()) continue;
            if (!pulse.canOverlap()) {
                pulse.added.forEach(this.occupied::remove);
            }
            iterator.remove();
        }
        while ((pulse = this.queue.poll()) != null) {
            spawns = pulse.tick(world);
            if (spawns != null) {
                if (pulse.canOverlap()) {
                    for (class_2338 pos : spawns) {
                        pulse.spawnParticles(world, pos);
                    }
                } else {
                    for (class_2338 pos : spawns) {
                        if (!this.occupied.add(pos)) continue;
                        pulse.spawnParticles(world, pos);
                        pulse.added.add(pos);
                    }
                }
            }
            this.pulses.add(pulse);
        }
    }

    public void addPulse(SoulPulseEffect pulse) {
        this.queue.offer(pulse);
    }

    public void refresh() {
        this.pulses.clear();
        this.occupied.clear();
    }
}

